#!/usr/bin/env zsh


if [ -z "$RASPISTUFF_DIR" ];then
    export RASPISTUFF_DIR="$(cd "$(dirname "$(readlink -f "${(%):-%x}")")" && pwd)"
fi


cd $RASPISTUFF_DIR 


if [ ! -f "$RASPISTUFF_DIR/secret/credentials_mqtt.sh" ]; then
    echo "$RASPISTUFF_DIR/secret/credentials_mqtt.sh not found. Will NOT listen for MQTT."
   exit 1
fi

source $RASPISTUFF_DIR/secret/credentials_mqtt.sh

shutdown_if_needed() {

  local payload=$1
  echo "TOPIC  $MQTT_TOPIC is now = $1"
  if [ "$payload" = "1" ]; then
    echo "Shutdown command received. Shutting down the system..."
 
   MSG_TITLE="✋ Shutdown $(hostname)"
   MSG_TEXT="MQTT Shutdown requested in $MQTT_TOPIC"
    
    NOTIFY_SCRIPT="$RASPISTUFF_DIR/notify.sh"
    #Requires MSG_TITLE and $MSG_TEXT to be defined!
    source "$NOTIFY_SCRIPT"
    
    echo "Will shutdown in 5 seconds..."
    sleep 5
    sudo shutdown -h now "MQTT requested shutdown in topic $MQTT_TOPIC"
  fi
}

while true; do

echo "listening to topic $MQTT_TOPIC "
mosquitto_sub -h "$MQTT_BROKER" -p "$MQTT_PORT" -t "$MQTT_TOPIC" -u "$MQTT_USER" -P "$MQTT_PASSWORD" | while read -r payload
do
  shutdown_if_needed "$payload"
done

echo "mosquitto client EXITEDi will try again in 5 minute"

sleep 300
done
