#!/usr/bin/env bash

# ------------------------------------------------------------------------------
# This will either allow automically with allowed IP or ask for auth otherwise
# in /etc/nginx/sites-available/search.lema.org
# ------------------------------------------------------------------------------
# satisfy any;
# include /etc/nginx/home_allow.conf;
# auth_basic "Restricted";
# auth_basic_user_file /etc/nginx/.htpasswd;
# ------------------------------------------------------------------------------

# ------------------------------------------------------------------------------
# call it every x minutes to stay up to day
# sudo crontab -e
# ------------------------------------------------------------------------------
# */5 * * * * /etc/nginx/update-home-ip.sh > /var/log/home_ip_update.log 2>&1
# ------------------------------------------------------------------------------


CNAME="casinha.lema.org"
INCLUDE_FILE="/etc/nginx/home_allow.conf"
CURRENT_IP=$(dig +short "$CNAME" | grep -Eo '([0-9]{1,3}\.){3}[0-9]{1,3}' | head -n 1)

if [[ -z "$CURRENT_IP" ]]; then
    echo "Could not resolve $CNAME"
    exit 1
fi

NEW_CONTENT="allow $CURRENT_IP;\ndeny all;"

# Only reload if IP changed
if ! grep -q "allow $CURRENT_IP;" "$INCLUDE_FILE"; then
    echo -e "$NEW_CONTENT" > "$INCLUDE_FILE"
    nginx -t && nginx -s reload
    echo "Updated Nginx allow list with IP $CURRENT_IP"
else
    echo "IP unchanged, nothing to do."
fi
