#!/usr/bin/env bash

if [ -z "$1" ]; then
  echo "Usage: $0 <URL>"
  exit 1
fi

if [[  -z "$SNAC_BASEDIR" ]]; then
  echo "Error: SNAC_BASEDIR must be set." >&2
  exit 1
fi

URL="$1"
ID="${URL##*/p/}"
PREFIX="${ID:0:2}"
FILE_PATH="$SNAC_BASEDIR/object/$PREFIX/$ID.json"

if [ ! -f "$FILE_PATH" ]; then
  echo "Post - File not found: $FILE_PATH"
  exit 2
fi

# Extract author and content
AUTHOR=$(jq -r '.attributedTo' "$FILE_PATH")
CONTENT=$(jq -r '.content' "$FILE_PATH" \
  | sed -e 's/<[bB][rR][[:space:]]*\/?>/\n/g' \
        -e 's/<[^>]*>//g')

# Print output
echo "$CONTENT"
echo
echo "Author: $AUTHOR"
echo "URL:  $URL"