#!/usr/bin/env zsh


wait_find_window_id() {
    while true; do
        window_id=$(wmctrl -l | grep "$1" | awk '{print $1}')
        if [ -n "$window_id" ]; then
            echo "$window_id"
            return
        fi
        sleep 0.05
    done
}

fix_window() {
    #hide title bar
xprop -f _MOTIF_WM_HINTS 32c -set _MOTIF_WM_HINTS "0x2, 0x0, 0x0, 0x0, 0x0" -id $1
}

resize_window() {
    #resize
    wmctrl -i -r "$1" -e 0,"$2","$3","$4","$5"
}

#window_id=$(wait_find_window_id "$window_name")

#echo "Window '$window_name' found with ID: $window_id"

#resize_window "$window_id" "$new_x" "$new_y" "$new_width" "$new_height"
