"upgrade_snac_to_head.sh" 36L, 604B                                                                                                         16,30         All
#!/usr/bin/env bash

#Pre existing cloned repo
cd $HOME/snac2

SNAC_USER=snac
SNAC_DATA=/home/snac/data

separator() {
    printf '=%.0s' $(seq $(tput cols))
    echo
}


git fetch
git reset --hard origin/master
echo "Building..."
make && sudo make install


separator
echo "Release notes (10 lines)"
separator
head RELEASE_NOTES.md -n 10

separator
echo "Upgrading snac data folder (user: $SNAC_USER data: $SNAC_DATA)..."
sudo -u $SNAC_USER snac upgrade $SNAC_DATA

separator
echo "Restarting service..."
sudo systemctl restart snac.service

separator
sudo -u $SNAC_USER snac state $SNAC_DATA
separator