#!/usr/bin/env zsh

# Use fzf and  open file in text editor

 vd() {
   # folder, default to current directory
   #  depth, default to 1 
    local dir=${1:-.}   
    local depth=${2:-1} 
    local selected_file
    
    while true; do
   selected_file=$(fzf --reverse --border --preview "if [ -d {} ]; then echo 'Folder: {}\nenter to cd'; else bat --style=plain --color=always {} ; fi" --preview-window=up:50%:wrap < <(find "$dir" -maxdepth "$depth"))


        # cd to folder or open in editor
        if [[ -n $selected_file ]]; then
            if [[ -d $selected_file ]]; then
                dir="$selected_file"
            else
                echo "$selected_file" | xargs "$EDITOR"
            fi
        else
            break
        fi
    done
    
}