#!/usr/bin/env bash
set -euo pipefail

POWER_LIMIT=30

power="$(nvidia-smi --query-gpu=power.draw --format=csv,noheader,nounits 2>/dev/null | head -n1)"

if [[ -z "$power" ]]; then
  echo "OOPS: cannot read GPU power - check nvidia GPU driver"
  exit 1
fi


# Numeric compare (decimal-safe)
if awk -v p="$power" -v t="$POWER_LIMIT" 'BEGIN { exit !(p < t) }'; then
  echo "Ignoring low GPU power ${power} W < ${POWER_LIMIT} W"
  exit 1
else
 echo "GPU Power is $power W  -- above idle limit ($POWER_LIMIT W)"
fi

# protect process containing one of these strings 
NOT_GAMES=(
  blender
  dontkillme
)

for s in "${NOT_GAMES[@]}"; do
  if ps -eo args \
     | grep -qi -- "$s" \
     | grep -qv grep; then
    echo "PROTECTED process matched, exiting '$s'"
    exit 1
  fi
done


echo "Games likely running with GPU ${power}W"
exit 0
