  #!/bin/bash                                                                 
  ZIMDIR=/hugedisk/kiwix/zims                                                 
  LIBRARY_XML=/hugedisk/kiwix/library.xml                                     
                                                                              
  pkill kiwix-serve                                                           
                                                                              
  touch $LIBRARY_XML                                                          
  echo "Will scan zimdir: $ZIMDIR"                                            
  for f in "$ZIMDIR"/*.zim; do                                                
    if [[ -f "$f" ]]; then                                                    
      echo "adding $f"                                                        
      ( set -x; kiwix-manage "$LIBRARY_XML" add $f )                          
    fi                                                                        
  done                                                                        
                                                                              
  kiwix-serve --port 8088 --monitorLibrary --library "$LIBRARY_XML"           
                                                                                                                             