#!/bin/sh

# RUN chromium in full screen with minimal SD-Card writes, runs OK on a Raspberry 3 with a webpage playing video

# ADD a ram disk in fstab with this line
# tmpfs /tmpcache tmpfs nodiratime,noatime,nosuid,nodev,size=256M 0 0

# and that this script is called on startup for a minimalistic (no desktop setup)
# /etc/xdg/openbox/autostart

# or (if you want to keep your desktop with other stuff)
# Insiide /home/pi/.config/lxsession/LXDE-pi
# @lxpanel --profile LXDE-pi
# @pcmanfm --desktop --profile LXDE-pi
# @xscreensaver -no-splash
# /home/pi/start_chromium_stats.sh > /var/log/auto_start_output_stats_browser.log 2>&1 & 

export DISPLAY=:0
# Disable any form of screen saver / screen blanking / power management
xset s off
xset s noblank
xset -dpms

unclutter -idle 0.01 &

# Allow quitting the X server with CTRL-ATL-Backspace
setxkbmap -option terminate:ctrl_alt_bksp

# Chromium keeps writing shit continuously in ~/.config/chromium
# BUT WE cannot kill it completely because Home Assistant requires a login to save
#mkdir /tmpcache/chromium_config_tmp
#rm -rf ~/.config/chromium/
#ln -s /tmpcache/chromium_config_tmp ~/.config/chromium

# Create links to RamDisk for most active files by chromium as observed using iotop / lsof 

rm -rf /home/pi/.config/chromium/Default/IndexedDB
mkdir /tmpcache/IndexedDB
ln -s /tmpcache/IndexedDB /home/pi/.config/chromium/Default/IndexedDB

rm -rf /home/pi/.config/chromium/Default/GPUCache
mkdir /tmpcache/GPUCache
ln -s /tmpcache/GPUCache /home/pi/.config/chromium/Default/GPUCache

rm -rf "/home/pi/.config/chromium/Default/Local Extension Settings"
mkdir /tmpcache/ChromeLocalExtensionSetttings
ln -s /tmpcache/ChromeLocalExtensionSetttings "/home/pi/.config/chromium/Default/Local Extension Settings"

rm -rf "/home/pi/.config/chromium/Default/QuotaManager-journal"
mkdir /tmpcache/ChromeQuotaManager-journal
ln -s /tmpcache/ChromeQuotaManager-journal "/home/pi/.config/chromium/Default/QuotaManager-journal"

rm -rf "/home/pi/.config/chromium/Default/QuotaManager"
mkdir /tmpcache/ChromeQuotaManager
ln -s /tmpcache/ChromeQuotaManager "/home/pi/.config/chromium/Default/QuotaManager"

sed -i 's/"exited_cleanly":false/"exited_cleanly":true/' ~/.config/chromium/'Local State'
sed -i 's/"exited_cleanly":false/"exited_cleanly":true/; s/"exit_type":"[^"]\+"/"exit_type":"Normal"/' ~/.config/chromium/Default/Preferences
nice -n 5 chromium-browser --disk-cache-dir=/tmpcache  --force-device-scale-factor=0.68 --disable-infobars --enable-features=OverlayScrollbar,OverlayScrollbarFlashAfterAnyScrollUpdate,OverlayScrollbarFlashWhenMouseEnter  --kiosk 'http://192.168.0.182:8123/lovelace-telacheia/0'

