#!/usr/bin/env bash

#Pre existing cloned repo
cd $HOME/snac2

SNAC_USER=snac
SNAC_DATA=/home/snac/data

separator() {
    printf '=%.0s' $(seq $(tput cols))
    echo
}

git fetch --tags
latest_tag=$(git tag --sort=-v:refname | head -n 1)
echo "Found latest tag : $latest_tag"
git reset --hard $latest_tag
git checkout $latest_tag

echo "Building..."
make && sudo make install


separator
echo "Release notes (10 lines)"
separator
head RELEASE_NOTES.md -n 10

separator
echo "Upgrading snac data folder (user: $SNAC_USER data: $SNAC_DATA)..."
sudo -u $SNAC_USER snac upgrade $SNAC_DATA

separator
echo "Restarting service..."
sudo systemctl restart snac.service

separator
sudo -u $SNAC_USER snac state $SNAC_DATA
separator
